//
//  TTTViewController.m
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 9/2/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import "TTTLoginViewController.h"
#import "TTTCheckpointManager.h"
#import "TTTUserManager.h"
#import "TTTLogger.h"


@implementation TTTLoginViewController
    @synthesize loginButton;
    @synthesize createNewUserButton;
    @synthesize exitButton;
    @synthesize useridTextField;
    @synthesize passwordTextField;
    @synthesize passwordLabel;

    TTTCheckpointManager *checkpointManager=nil;
    NSMutableArray *users=nil;
    TTTUser *currentUser=nil;
    NSInteger currentUserIndex=-1;
    TTTLogger* myLogger;


    // Needed for Core Data
    NSManagedObjectContext *managedObjectContext;

    + (TTTAppDelegate *) sharedAppDelegate {
        return (TTTAppDelegate*)[[UIApplication sharedApplication] delegate];
    }

#pragma lifecycle methods

    - (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil{
        self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
        if (self) {
            // Custom initialization
        }
        return self;
    }

    - (void)viewDidLoad{
        [super viewDidLoad];
        // Do any additional setup after loading the view.
        
        // Load the Core Data context
        managedObjectContext = [[TTTLoginViewController sharedAppDelegate] managedObjectContext];
        // Load all the existing users
        // TTTUserManager* myUserManager = [TTTUserManager TTTUserManagerCreate];
        // if(users == nil) users = [myUserManager getAllUsersFromDB];
        
        // Set the password field to hide what is typed in
        // passwordTextField.secureTextEntry = YES;
        
        // Register with the checkpoint manager
        
        checkpointManager = [TTTCheckpointManager CreateManager];
        [checkpointManager registerObjectWithKey :@"TTTLoginViewController" :self];
        
        // Set up the logger
        myLogger = [TTTLogger CreateLogger];
    }

    - (void)didReceiveMemoryWarning{
        [super didReceiveMemoryWarning];
        // Dispose of any resources that can be recreated.
    }

    - (void) checkpoint{
        [self clearFields];
    }

#pragma user interface prompts, actions, callback handlers and other methods

    - (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex{
        return;
    }

    - (void) showMessage :(NSString *) title :(NSString *) message{
        UIAlertView *alert = [[UIAlertView alloc] init];
        [alert setTitle:title];
        [alert setMessage:message];
        [alert addButtonWithTitle:@"Continue"];
        [alert setDelegate:self];
        [alert show];
    }

    - (BOOL)textFieldShouldReturn:(UITextField *)textField {
        [textField resignFirstResponder];
        return NO;
    }

    -(IBAction)doneEnteringText:(id)sender{
        UITextField *theField = (UITextField*)sender;
        // [passwordLabel setText:@"Tell me all!"];
        [theField resignFirstResponder];
    }

    - (IBAction)login:(id)sender{

        NSString* oneUserid = [useridTextField text];
        NSString* onePassword = [passwordTextField text];
        [self clearFields];
        TTTUserManager* myUserManager = [TTTUserManager CreateUserManager];
        if ([myUserManager useridPassWordMatch :oneUserid :onePassword]){ // Login successful
            NSString * logEntry = [[NSArray arrayWithObjects :NSStringFromClass([self class]),
                                                              NSStringFromSelector(_cmd),
                                                              oneUserid, onePassword,
                                                              @"Successful login",nil]
                                   componentsJoinedByString:@":"];
            [myLogger log:logEntry];
            
            // Done with this view controller, unregister checkpoint
            
            [checkpointManager unregisterObjectWithKey :@"TTTLoginViewController"];

            // Segue to GameOptions scene
            [self performSegueWithIdentifier:@"SuccessfulLogin" sender:self];
        }else{
            [self showMessage :@"Login Failed!" :@"Check userid and password"];
            NSString * logEntry = [[NSArray arrayWithObjects :NSStringFromClass([self class]),
                                                               NSStringFromSelector(_cmd),
                                                              oneUserid, onePassword,
                                                              @"Unsuccessful login",nil]
                                   componentsJoinedByString:@":"];
            [myLogger log:logEntry];
        }
    }

    - (IBAction)createNewUser:(id)sender{
        NSString* logEntry = nil;
        NSString *newUserID = [useridTextField text];
        NSString *newPassword = [passwordTextField text];
        if(![newUserID isEqualToString:@""] && ![newPassword isEqualToString:@""]){
            TTTUserManager* myUserManager = [TTTUserManager CreateUserManager];
            BOOL result = [myUserManager addNewUser:newUserID :newPassword];
            if (result == TRUE){
                logEntry = [[NSArray arrayWithObjects :NSStringFromClass([self class]),
                                                       NSStringFromSelector(_cmd),
                                                       newUserID,
                                                       newPassword,
                                                       @"User successfully created",
                                                       nil]
                             componentsJoinedByString:@":"];
                [self showMessage :@"SUCCESS!" :@"User  created"];
            }else {
                logEntry = [[NSArray arrayWithObjects :NSStringFromClass([self class]),
                                                       NSStringFromSelector(_cmd),
                                                       newUserID,
                                                       newPassword,
                                                       @"User could not be created",
                                                       nil]
                            componentsJoinedByString:@":"];
                 [self showMessage :@"FAILURE!" :@"Userid already exists"];
            }
            [myLogger log:logEntry];
        }else{
            [self showMessage :@"Cannot create users with blank values!" :@"Check userid and password"];
        }
    }

    - (IBAction)exit:(id)sender{
        TTTLogger *myLogger = [TTTLogger CreateLogger];
        [myLogger writeLogToNSLog];
        exit(0); // Not recommended by Apple - do not do in a real app
    }

    - (void) clearFields{
        useridTextField.text = @"";
        passwordTextField.text = @"";
    }


@end
